#ifndef LINT
static char SCCSid[] = "@(#)PRESAT.c 18.1 06/25/04 Copyright (c) 1991-1998 Varian Assoc.,Inc. All Rights Reserved";
#endif
/* 
 * Varian Assoc.,Inc. All Rights Reserved.
 * This software contains proprietary and confidential
 * information of Varian Assoc., Inc. and its contributors.
 * Use, disclosure and reproduction is prohibited without
 * prior consent.
 */
/*  PRESAT - standard two-pulse sequence with presaturation option

	Paramters:
		satmode	:	y - selects presaturation option
		satfrq	:	presaturation frequency
		satdly	:	presaturation delay
		satpwr	:	presaturation power
		pw	:	Observe pulse width
		d1	:	relaxation delay

KrishK	-	Last revision	: June 1997

*/


#include <standard.h>

static int phs1[4] = {0,2,1,3},
	   phs2[8] = {0,0,1,1,2,2,3,3};


pulsesequence()
{
  double 	satfrq,
		satdly,
		satpwr;
  char		satmode[MAXSTR];

  satfrq = getval("satfrq");
  satdly = getval("satdly");
  satpwr = getval("satpwr");
  getstr("satmode",satmode);

  settable(t1,4,phs1);
  settable(t2,8,phs2);
  getelem(t1,ct,oph);

   status(A);
   hsdelay(d1);

        if (satmode[0] == 'y')
        {
                if (satfrq != tof)
                obsoffset(satfrq);
                obspower(satpwr);
                rgpulse(satdly,t2,rof1,rof1);
                obspower(tpwr);
                if (satfrq != tof)
                obsoffset(tof);
        }

   status(B);

   pulse(p1,zero); 
   hsdelay(d2); 
   
   status(C);
   pulse(pw,oph);
}
